#!/bin/sh
rootdir=$(dirname "$PWD")
echo "rootdir: ${rootdir}"

root_conf=${rootdir}/admin/conf.ini

mrcp_server_conf=${rootdir}/conf/unimrcpserver.xml
mrcp_client_conf=${rootdir}/conf/unimrcpclient.xml
mrcp_client_server_conf=${rootdir}/conf/client-profiles/unimrcp.xml

vad_conf=${rootdir}/conf/vad_configure_8k
asr_conf=${rootdir}/conf/TCloudRealtimeASRConfig.ini
private_asr_conf=${rootdir}/conf/TCloudPrivateRealtimeASRConfig.ini
tts_auth_conf=${rootdir}/conf/tcloud_auth.ini 
tts_url_conf=${rootdir}/conf/request_parameter.ini

sed "s|ROOTDIR|${rootdir}|g" ${rootdir}/model/vad_configure_8k > ${vad_conf}

recog_audio_save=$(cat $root_conf | grep "recog_audio_save" | awk -F '=' '{print $2}')
echo "recog_audio_save: $recog_audio_save"
synth_audio_save=$(cat $root_conf | grep "synth_audio_save" | awk -F '=' '{print $2}')
echo "synth_audio_save: $synth_audio_save"
server_ip=$(cat $root_conf | grep "server_ip" | awk -F '=' '{print $2}')
echo "server_ip: $server_ip"
server_sip_port=$(cat $root_conf | grep "server_sip_port" | awk -F '=' '{print $2}')
echo "server_sip_port: $server_sip_port"
server_mrcp_port=$(cat $root_conf | grep "server_mrcp_port" | awk -F '=' '{print $2}')
echo "server_mrcp_port: $server_mrcp_port"
server_rtp_port_min=$(cat $root_conf | grep "server_rtp_port_min" | awk -F '=' '{print $2}')
echo "server_rtp_port_min: $server_rtp_port_min"
server_rtp_port_max=$(cat $root_conf | grep "server_rtp_port_max" | awk -F '=' '{print $2}')
echo "server_rtp_port_max: $server_rtp_port_max"
sed "s|SERVERIP|${server_ip}|g;s|SIPPORT|${server_sip_port}|g;s|MRCPPORT|${server_mrcp_port}|g;s|RTPMIN|${server_rtp_port_min}|g;s|RTPMAX|${server_rtp_port_max}|g;s|RECOGSAVESWITCH|${recog_audio_save}|g;s|SYNTHSAVESWITCH|${synth_audio_save}|g" ${rootdir}/model/unimrcpserver.xml > ${mrcp_server_conf}

client_sip_port=$(cat $root_conf | grep "client_sip_port" | awk -F '=' '{print $2}')
echo "client_sip_port: $client_sip_port"
client_rtp_port_min=$(cat $root_conf | grep "client_rtp_port_min" | awk -F '=' '{print $2}')
echo "client_rtp_port_min: $client_rtp_port_min"
client_rtp_port_max=$(cat $root_conf | grep "client_rtp_port_max" | awk -F '=' '{print $2}')
echo "client_rtp_port_max: $client_rtp_port_max"
sed "s|CLIENTIP|${server_ip}|g;s|SIPPORT|${client_sip_port}|g;s|RTPMIN|${client_rtp_port_min}|g;s|RTPMAX|${client_rtp_port_max}|g" ${rootdir}/model/unimrcpclient.xml > ${mrcp_client_conf}
sed "s|SIPPORT|${server_sip_port}|g;s|SERVERIP|${server_ip}|g" ${rootdir}/model/unimrcp.xml > ${mrcp_client_server_conf}


appid=$(cat $root_conf | grep "appid" | awk -F '=' '{print $2}')
echo "appid: $appid"
secretid=$(cat $root_conf | grep "secretid" | awk -F '=' '{print $2}')
echo "secretid: $secretid"
secretkey=$(cat $root_conf | grep "secretkey" | awk -F '=' '{print $2}')
echo "secretkey: $secretkey"
sed "s|APPID|${appid}|g;s|SECRETID|${secretid}|g;s|SECRETKEY|${secretkey}|g" ${rootdir}/model/tcloud_auth.ini > ${tts_auth_conf}

is_private=$(cat $root_conf | grep "is_private" | awk -F '=' '{print $2}')
echo "is_private: $is_private"
asr_request_url=$(cat $root_conf | grep "^asr_request_url" | awk -F '=' '{print $2}')
echo "asr_request_url: $asr_request_url"
sed "s|REQUESTURL|${asr_request_url}|g" ${rootdir}/model/TCloudPrivateRealtimeASRConfig.ini > ${private_asr_conf}
sed "s|REQUESTURL|${asr_request_url}|g;s|APPID|${appid}|g;s|SECRETID|${secretid}|g;s|SECRETKEY|${secretkey}|g;s|IS_PRIVATE|${is_private}|g" ${rootdir}/model/TCloudRealtimeASRConfig.ini > ${asr_conf}

tts_request_url=$(cat $root_conf | grep "^tts_request_url" | awk -F '=' '{print $2}')
echo "tts_request_url: $tts_request_url"
sed "s|REQUESTURL|${tts_request_url}|g" ${rootdir}/model/request_parameter.ini > ${tts_url_conf}

