/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.springsecurity4.crypto.password;

import org.jasypt.digest.StringDigester;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.jasypt.util.password.PasswordEncryptor;

public final class PasswordEncoder
implements org.springframework.security.crypto.password.PasswordEncoder {
    private PasswordEncryptor passwordEncryptor = null;
    private StringDigester stringDigester = null;
    private Boolean useEncryptor = null;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
        this.useEncryptor = Boolean.TRUE;
    }

    public void setStringDigester(StringDigester stringDigester) {
        this.stringDigester = stringDigester;
        this.useEncryptor = Boolean.FALSE;
    }

    public String encode(CharSequence rawPassword) {
        this.checkInitialization();
        if (this.useEncryptor.booleanValue()) {
            return this.passwordEncryptor.encryptPassword(rawPassword.toString());
        }
        return this.stringDigester.digest(rawPassword.toString());
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        this.checkInitialization();
        if (this.useEncryptor.booleanValue()) {
            return this.passwordEncryptor.checkPassword(rawPassword.toString(), encodedPassword);
        }
        return this.stringDigester.matches(rawPassword.toString(), encodedPassword);
    }

    private synchronized void checkInitialization() {
        if (this.useEncryptor == null) {
            this.passwordEncryptor = new BasicPasswordEncryptor();
            this.useEncryptor = Boolean.TRUE;
        } else if (this.useEncryptor.booleanValue()) {
            if (this.passwordEncryptor == null) {
                throw new EncryptionInitializationException("Password encoder not initialized: password encryptor is null");
            }
        } else if (this.stringDigester == null) {
            throw new EncryptionInitializationException("Password encoder not initialized: string digester is null");
        }
    }
}

